package errors

import "errors"

type wrappedErr struct {
	Err     error
	Wrapped error
}

func WrapErr(err, wrapped error) error {
	if wrapped == nil {
		return nil
	}
	return &wrappedErr{
		Err:     err,
		Wrapped: wrapped,
	}
}

func (w *wrappedErr) Error() string {
	return w.Err.Error()
}

func (w *wrappedErr) WrappedErrors() []error {
	return []error{w.Err, w.Wrapped}
}

func (w *wrappedErr) Unwrap() error {
	return w.Wrapped
}

func (w *wrappedErr) Is(target error) bool {
	return errors.Is(w.Err, target)
}

func (w *wrappedErr) As(target interface{}) bool {
	return errors.As(w.Err, target)
}
