package errors

import (
	"github.com/pkg/errors"
)

var WithStack = errors.WithStack

type StackTrace = errors.StackTrace

type StackTracer interface {
	StackTrace() errors.StackTrace
}

func GetStackTrace(err error) (StackTrace, bool) {
	if s := getStackTracer(err); s != nil {
		return s.StackTrace(), true
	}

	return nil, false
}

func getStackTracer(err error) StackTracer {
	for e := err; e != nil; e = Unwrap(e) {
		if s, ok := err.(StackTracer); ok {
			return s
		}
	}
	return nil
}
