package errors

type Help struct {
	Links []HelpLink
}

type HelpLink struct {
	Description string
	URL         string
}

type HelpError interface{ Help() *Help }

type withHelp struct {
	err  error
	help *Help
}

func (w *withHelp) Help() *Help   { return w.help }
func (w *withHelp) Error() string { return w.err.Error() }
func (w *withHelp) Unwrap() error { return w.err }

//func (w *withHelp) Format(s fmt.State, verb rune) {
//	switch verb {
//	case 'v':
//		if s.Flag('+') {
//			fmt.Fprintf(s, "%+v", w.Unwrap())
//			fmt.Fprintf(s, "\nerror hint: %s", w.hint)
//			return
//		}
//		fallthrough
//	case 's':
//		io.WriteString(s, w.Error())
//	case 'q':
//		fmt.Fprintf(s, "%q", w.Error())
//	}
//}

func WithHelp(err error, help *Help) error {
	if err == nil {
		return nil
	}
	return &withHelp{err: err, help: help}
}

func GetHelp(err error) *Help {
	var help Help
	for e := err; e != nil; e = Unwrap(e) {
		if errHelp, ok := e.(HelpError); ok {
			h := errHelp.Help()
			if h != nil && len(h.Links) > 0 {
				help.Links = append(help.Links, h.Links...)
			}
		}
	}

	if len(help.Links) > 0 {
		return &help
	}

	return nil
}
