package grpc

import (
	"context"

	"github.com/go-kit/kit/endpoint"
	"google.golang.org/grpc/status"
)

func ServerMiddleware(ep endpoint.Endpoint) endpoint.Endpoint {
	return func(ctx context.Context, request interface{}) (response interface{}, err error) {
		response, err = ep(ctx, request)
		if err != nil {
			if st := StatusFromError(err); st != nil {
				err = st.Err()
			}

		}
		return response, err
	}
}

func ClientMiddleware(ep endpoint.Endpoint) endpoint.Endpoint {
	return func(ctx context.Context, request interface{}) (response interface{}, err error) {
		response, err = ep(ctx, request)
		if err != nil {
			st, _ := status.FromError(err)
			err = ErrorFromStatus(st)
		}
		return response, err
	}
}
