package errors

type ErrContext interface{ Context() []interface{} }

type withContext struct {
	err error
	kv  []interface{}
}

func (w *withContext) Context() []interface{} { return w.kv }
func (w *withContext) Error() string          { return w.err.Error() }
func (w *withContext) Cause() error           { return w.err }
func (w *withContext) Unwrap() error          { return w.err }

// WithContext добавляет контекст к ошибке
func WithContext(err error, kv ...interface{}) error {
	for e := err; e != nil; e = Unwrap(e) {
		if wc, ok := e.(*withContext); ok {
			wc.kv = append(wc.kv, kv...)
			return err
		}
	}
	return &withContext{
		err: err,
		kv:  kv,
	}
}

// Context возвращает контекст из ошибки
func Context(err error) []interface{} {
	for e := err; e != nil; e = Unwrap(e) {
		if errContext, ok := e.(ErrContext); ok {
			return errContext.Context()
		}
	}
	return nil
}

// ContextKey возвращает значение ключа из контекста ошибки
func ContextKey(err error, key interface{}) (interface{}, bool) {
	if kv := Context(err); kv != nil {
		var i int
		for {
			if i >= len(kv) {
				return nil, false
			}
			v := kv[i]
			if v == key {
				return kv[i+1], true
			}
			i += 2
		}
	}
	return nil, false
}
