package environments

import "context"

type Storage interface {
	Create(ctx context.Context, create *Environment) (environment *Environment, err error)
	Get(ctx context.Context, spaceId, envId string) (env *Environment, err error)
	List(ctx context.Context, spaceId string) (envs []*Environment, err error)
	Update(ctx context.Context, up *Environment, options ...*UpdateOptions) (updated, total int, err error)
	Delete(ctx context.Context, spaceId, envId string) (err error)
	SetAlias(ctx context.Context, spaceId, envId, alias string) (err error)
	RemoveAlias(ctx context.Context, spaceId, envId, alias string) (err error)

	Reset(ctx context.Context, spaceId string)
	Init(ctx context.Context, spaceID string) error
}
