package environments

type MigrateOptions struct {
	// Async - запустить миграцию в асинхронном режиме
	Async bool
}

func MergeMigrateOptions(opts ...*MigrateOptions) *MigrateOptions {
	o := &MigrateOptions{}
	for _, opt := range opts {
		if opt.Async {
			o.Async = true
		}
	}
	return o
}

type UpdateOptions struct {

	// Состояние будет обновлено только в том случае, если выполняется указанное условие
	// Cond указывается с использованием синтаксиса `expr`
	Cond string
}

func MergeUpdateOptions(opts ...*UpdateOptions) *UpdateOptions {
	o := &UpdateOptions{}
	for _, opt := range opts {
		if opt.Cond != "" {
			if o.Cond != "" {
				o.Cond += " && "
			}
			o.Cond += opt.Cond
		}
	}
	return o
}
