package content

import (
	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/clients"
	"git.perx.ru/perxis/perxis-go/pkg/collaborators"
	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/environments"
	"git.perx.ru/perxis/perxis-go/pkg/invitations"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/locales"
	"git.perx.ru/perxis/perxis-go/pkg/references"
	"git.perx.ru/perxis/perxis-go/pkg/roles"
	"git.perx.ru/perxis/perxis-go/pkg/spaces"
	"git.perx.ru/perxis/perxis-go/pkg/version"
)

type Runnable interface {
	Start()
	Stop()
}

type Content struct {
	collaborators.Collaborators
	collections.Collections
	environments.Environments
	invitations.Invitations
	items.Items
	references.References
	locales.Locales
	roles.Roles
	spaces.Spaces
	clients.Clients
	version.Versions

	PrincipalFactory *auth.PrincipalFactory

	runners []Runnable
}

const (
	DBVersion uint32 = 2
)

func (c *Content) RegisterStart(svc interface{}) {
	if r, ok := svc.(Runnable); ok {
		c.runners = append(c.runners, r)
	}
}

func (c Content) Start() {
	for _, r := range c.runners {
		r.Start()
	}
}

func (c Content) Stop() {
	for _, r := range c.runners {
		r.Stop()
	}
}
