package content

import (
	kitgrpc "github.com/go-kit/kit/transport/grpc"
	"go.uber.org/zap"
)

type Config struct {
	NoCache   bool
	NoLog     bool
	AccessLog bool
	Debug     bool
	NoDecode  bool

	ClientOptions []kitgrpc.ClientOption
	Logger        *zap.Logger
}

type Option func(c *Config)

func NoCache() Option {
	return func(c *Config) {
		c.NoCache = true
	}
}

func NoLog() Option {
	return func(c *Config) {
		c.NoLog = true
	}
}

func Logger(logger *zap.Logger) Option {
	return func(c *Config) {
		c.Logger = logger
	}
}

func AccessLog() Option {
	return func(c *Config) {
		c.AccessLog = true
	}
}

func GrpcClientOptions(opts ...kitgrpc.ClientOption) Option {
	return func(c *Config) {
		c.ClientOptions = opts
	}
}
