package collections

import (
	"context"
)

type Storage interface {
	Reset(ctx context.Context, spaceId, envId string) error
	Init(ctx context.Context, spaceID, envID string) error

	Create(ctx context.Context, coll *Collection) (created *Collection, err error)
	Get(ctx context.Context, spaceId, envId, collectionId string) (collection *Collection, err error)
	List(ctx context.Context, spaceId, envId string, filter *Filter) (collections []*Collection, err error)
	Update(ctx context.Context, coll *Collection) (updated, total int, err error)
	Delete(ctx context.Context, spaceId, envId, collectionId string) (err error)
}
