package collections

import "context"

// CollectionCreatedObserver интерфейс наблюдателя вызываемый при создании коллекции.
// Инициировать оповещение наблюдателя может вызов метода `Collection.Create`
type CollectionCreatedObserver interface {
	OnCollectionCreated(ctx context.Context, coll *Collection) (delayedTaskID string, err error)
}

// CollectionUpdatedObserver интерфейс наблюдателя вызываемый при изменении коллекции.
// Инициировать оповещение наблюдателя может вызов методов `Collection.Update`
type CollectionUpdatedObserver interface {
	OnCollectionUpdated(ctx context.Context, before, after *Collection) (delayedTaskID string, err error)
}

// CollectionSetSchemaObserver интерфейс наблюдателя вызываемый при изменении схемы коллекции.
// Инициировать оповещение наблюдателя может вызов методов `Collection.Schema`
type CollectionSetSchemaObserver interface {
	OnCollectionSetSchema(ctx context.Context, before, coll *Collection) (delayedTaskID string, err error)
}

// CollectionDeletedObserver интерфейс наблюдателя вызываемый при удалении коллекции.
// Инициировать оповещение наблюдателя может вызов метода `Collection.Delete`
type CollectionDeletedObserver interface {
	OnCollectionDeleted(ctx context.Context, coll *Collection) (delayedTaskID string, err error)
}

// CollectionPreUpdateObserver интерфейс наблюдателя вызываемый при перед обновлением коллекции.
// Инициировать оповещение наблюдателя может вызов методов `Collection.Update`
type CollectionPreUpdateObserver interface {
	OnCollectionPreUpdate(ctx context.Context, before, coll *Collection) (delayedTaskID string, err error)
}
