// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/telemetry
// gowrap: http://github.com/hexdigest/gowrap

package middleware

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/collections -i Collections -t ../../../assets/templates/middleware/telemetry -o telemetry_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/schema"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
)

// telemetryMiddleware implements collections.Collections interface instrumented with opentracing spans
type telemetryMiddleware struct {
	collections.Collections
	_instance      string
	_spanDecorator func(span trace.Span, params, results map[string]interface{})
}

// TelemetryMiddleware returns telemetryMiddleware
func TelemetryMiddleware(base collections.Collections, instance string, spanDecorator ...func(span trace.Span, params, results map[string]interface{})) telemetryMiddleware {
	d := telemetryMiddleware{
		Collections: base,
		_instance:   instance,
	}

	if len(spanDecorator) > 0 && spanDecorator[0] != nil {
		d._spanDecorator = spanDecorator[0]
	}

	return d
}

// Create implements collections.Collections
func (_d telemetryMiddleware) Create(ctx context.Context, collection *collections.Collection) (created *collections.Collection, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.Create")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":        ctx,
				"collection": collection}, map[string]interface{}{
				"created": created,
				"err":     err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.Create(ctx, collection)
}

// Delete implements collections.Collections
func (_d telemetryMiddleware) Delete(ctx context.Context, spaceId string, envId string, collectionId string) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.Delete")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.Delete(ctx, spaceId, envId, collectionId)
}

// Get implements collections.Collections
func (_d telemetryMiddleware) Get(ctx context.Context, spaceId string, envId string, collectionId string, options ...*collections.GetOptions) (collection *collections.Collection, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.Get")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"options":      options}, map[string]interface{}{
				"collection": collection,
				"err":        err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.Get(ctx, spaceId, envId, collectionId, options...)
}

// List implements collections.Collections
func (_d telemetryMiddleware) List(ctx context.Context, spaceId string, envId string, filter *collections.Filter) (collections []*collections.Collection, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.List")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId,
				"envId":   envId,
				"filter":  filter}, map[string]interface{}{
				"collections": collections,
				"err":         err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.List(ctx, spaceId, envId, filter)
}

// SetSchema implements collections.Collections
func (_d telemetryMiddleware) SetSchema(ctx context.Context, spaceId string, envId string, collectionId string, schema *schema.Schema) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.SetSchema")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"schema":       schema}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.SetSchema(ctx, spaceId, envId, collectionId, schema)
}

// SetState implements collections.Collections
func (_d telemetryMiddleware) SetState(ctx context.Context, spaceId string, envId string, collectionId string, state *collections.StateInfo) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.SetState")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"state":        state}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.SetState(ctx, spaceId, envId, collectionId, state)
}

// Update implements collections.Collections
func (_d telemetryMiddleware) Update(ctx context.Context, coll *collections.Collection) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Collections.Update")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":  ctx,
				"coll": coll}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Collections.Update(ctx, coll)
}
