package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/collections -i Collections -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/schema"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements collections.Collections that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   collections.Collections
}

// ErrorLoggingMiddleware instruments an implementation of the collections.Collections with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next collections.Collections) collections.Collections {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Create(ctx context.Context, collection *collections.Collection) (created *collections.Collection, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Create(ctx, collection)
}

func (m *errorLoggingMiddleware) Delete(ctx context.Context, spaceId string, envId string, collectionId string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Delete(ctx, spaceId, envId, collectionId)
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, spaceId string, envId string, collectionId string, options ...*collections.GetOptions) (collection *collections.Collection, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, spaceId, envId, collectionId, options...)
}

func (m *errorLoggingMiddleware) List(ctx context.Context, spaceId string, envId string, filter *collections.Filter) (collections []*collections.Collection, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.List(ctx, spaceId, envId, filter)
}

func (m *errorLoggingMiddleware) SetSchema(ctx context.Context, spaceId string, envId string, collectionId string, schema *schema.Schema) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.SetSchema(ctx, spaceId, envId, collectionId, schema)
}

func (m *errorLoggingMiddleware) SetState(ctx context.Context, spaceId string, envId string, collectionId string, state *collections.StateInfo) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.SetState(ctx, spaceId, envId, collectionId, state)
}

func (m *errorLoggingMiddleware) Update(ctx context.Context, coll *collections.Collection) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Update(ctx, coll)
}
