package collaborators

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Set(ctx context.Context, collaborator *Collaborator) (err error)
	Delete(ctx context.Context, filter *Filter) (total int, err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (collaborators []*Collaborator, err error)

	Reset(ctx context.Context) error
	Init(ctx context.Context) error
}

type Filter struct {
	SpaceID string `bson:"spaceId"`
	Subject string `bson:"userId"`
	Role    string `bson:"role"`
}
