package collaborators

import (
	"context"
)

// @microgen grpc, recovering, middleware
// @protobuf git.perx.ru/perxis/perxis-go/proto/collaborators
// @grpc-addr content.collaborators.Collaborators
type Collaborators interface {

	// Set - устанавливает участие пользователя в пространстве и его роль
	Set(ctx context.Context, spaceId, subject, role string) (err error)

	// Get - возвращает роль пользователя в пространстве
	Get(ctx context.Context, spaceId, subject string) (role string, err error)

	// Remove - удаляет участие пользователя в пространстве
	Remove(ctx context.Context, spaceId, subject string) (err error)

	// ListCollaborators - возвращает участников пространства и их ролей
	ListCollaborators(ctx context.Context, spaceId string) (collaborators []*Collaborator, err error)

	// ListSpaces - возвращает список пространств пользователя
	ListSpaces(ctx context.Context, subject string) (spaces []*Collaborator, err error)
}
