package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/collaborators -i Collaborators -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collaborators"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements collaborators.Collaborators that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   collaborators.Collaborators
}

// ErrorLoggingMiddleware instruments an implementation of the collaborators.Collaborators with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next collaborators.Collaborators) collaborators.Collaborators {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, spaceId string, subject string) (role string, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, spaceId, subject)
}

func (m *errorLoggingMiddleware) ListCollaborators(ctx context.Context, spaceId string) (collaborators []*collaborators.Collaborator, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.ListCollaborators(ctx, spaceId)
}

func (m *errorLoggingMiddleware) ListSpaces(ctx context.Context, subject string) (spaces []*collaborators.Collaborator, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.ListSpaces(ctx, subject)
}

func (m *errorLoggingMiddleware) Remove(ctx context.Context, spaceId string, subject string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Remove(ctx, spaceId, subject)
}

func (m *errorLoggingMiddleware) Set(ctx context.Context, spaceId string, subject string, role string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Set(ctx, spaceId, subject, role)
}
