package clients

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Create(ctx context.Context, client *Client) (*Client, error)
	Find(ctx context.Context, spaceId string, filter *Filter, opts *options.FindOptions) ([]*Client, int, error)
	Update(ctx context.Context, upd *Client) (updated, total int, err error)
	Delete(ctx context.Context, spaceId, id string) error

	Reset(ctx context.Context, spaceId string) error
	Init(ctx context.Context, spaceID string) error
}

type Filter struct {
	ID   string
	Name string

	GetByParams
}
