package clients

import (
	"context"
)

type GetByParams struct {
	OAuthClientID string `json:"oauth_client_id,omitempty"`
	APIKey        string `json:"api_key,omitempty"`
	TLSSubject    string `json:"tls_subject,omitempty"`
}

// @microgen grpc, recovering, middleware
// @protobuf git.perx.ru/perxis/perxis-go/proto/clients
// @grpc-addr content.clients.Clients
type Clients interface {
	// Create - создает клиента (приложение) для работы с API
	Create(ctx context.Context, client *Client) (created *Client, err error)

	// Get - возвращает клиента по id
	Get(ctx context.Context, spaceId, id string) (client *Client, err error)

	// GetBy - возвращает клиента по идентификатору системы авторизации
	GetBy(ctx context.Context, spaceId string, params *GetByParams) (client *Client, err error)

	// List - возвращает список клиентов созданных в пространстве
	List(ctx context.Context, spaceId string) (clients []*Client, err error)

	// Update - обновляет параметры клиента
	Update(ctx context.Context, client *Client) (err error)

	// Delete - удаляет указанного клиента из пространстве
	Delete(ctx context.Context, spaceId, id string) (err error)

	// Enable - активирует/деактивирует клиента. Клиент не сможет обращаться к API платформы
	Enable(ctx context.Context, spaceId, id string, enable bool) (err error)
}
