package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/clients -i Clients -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/clients"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements clients.Clients that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   clients.Clients
}

// ErrorLoggingMiddleware instruments an implementation of the clients.Clients with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next clients.Clients) clients.Clients {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Create(ctx context.Context, client *clients.Client) (created *clients.Client, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Create(ctx, client)
}

func (m *errorLoggingMiddleware) Delete(ctx context.Context, spaceId string, id string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Delete(ctx, spaceId, id)
}

func (m *errorLoggingMiddleware) Enable(ctx context.Context, spaceId string, id string, enable bool) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Enable(ctx, spaceId, id, enable)
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, spaceId string, id string) (client *clients.Client, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, spaceId, id)
}

func (m *errorLoggingMiddleware) GetBy(ctx context.Context, spaceId string, params *clients.GetByParams) (client *clients.Client, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.GetBy(ctx, spaceId, params)
}

func (m *errorLoggingMiddleware) List(ctx context.Context, spaceId string) (clients []*clients.Client, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.List(ctx, spaceId)
}

func (m *errorLoggingMiddleware) Update(ctx context.Context, client *clients.Client) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Update(ctx, client)
}
