package auth

import (
	"context"
)

type principalKey struct{}

func GetPrincipal(ctx context.Context) Principal {
	p, _ := ctx.Value(principalKey{}).(Principal)
	if p == nil {
		return Anonymous{}
	}
	return p
}

func WithPrincipal(ctx context.Context, p Principal) context.Context {
	if ctx == nil {
		ctx = context.Background()
	}

	return context.WithValue(ctx, principalKey{}, p)
}

func WithSystem(ctx context.Context) context.Context {
	return WithPrincipal(ctx, &SystemPrincipal{})
}
