package account

import (
	kitgrpc "github.com/go-kit/kit/transport/grpc"
	"go.uber.org/zap"
)

type config struct {
	noCache       bool
	noLog         bool
	accessLog     bool
	debug         bool
	clientOptions []kitgrpc.ClientOption // todo: можно заменить на grpc-интерсепторы при соединении и избавиться здесь от go-kit
	logger        *zap.Logger
}

type Option func(c *config)

func NoCache() Option {
	return func(c *config) {
		c.noCache = true
	}
}

func NoLog() Option {
	return func(c *config) {
		c.noLog = true
	}
}

func GrpcClientOptions(opts ...kitgrpc.ClientOption) Option {
	return func(c *config) {
		c.clientOptions = opts
	}
}

func Logger(logger *zap.Logger) Option {
	return func(c *config) {
		c.logger = logger
	}
}

func AccessLog() Option {
	return func(c *config) {
		c.accessLog = true
	}
}
