package account

import (
	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/members"
	msobserver "git.perx.ru/perxis/perxis-go/pkg/members/observer"
	"git.perx.ru/perxis/perxis-go/pkg/organizations"
	"git.perx.ru/perxis/perxis-go/pkg/users"
	"git.perx.ru/perxis/perxis-go/pkg/version"
	"google.golang.org/grpc"
)

type Account struct {
	users.Users
	members.Members
	organizations.Organizations
	version.Versions

	// сервис, отвечающий за отслеживание сервисом `members` событий от других сервисов
	MembersObserver msobserver.Observer

	// используется для добавления в контекст информации о пользователе, инициировавшем запрос
	PrincipalFactory *auth.PrincipalFactory

	ClientConn *grpc.ClientConn
}
