package version

import (
	"context"
	"fmt"
)

type Versions interface {
	Get(ctx context.Context) (version *Version, err error)
}

type Version struct {
	ServerVersion string
	APIVersion    string
	Commit        string
	BuildTime     string
	BuildNumber   int
}

func (v *Version) String() string {
	return fmt.Sprintf("%s-api%s-%s build: %d (%s)", v.ServerVersion, v.APIVersion, v.Commit, v.BuildNumber, v.BuildTime)
}
