package users

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Create(ctx context.Context, create *User) (user *User, err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (users []*User, total int, err error)
	Update(ctx context.Context, update *User, filter *Filter) (updated, total int, err error)
	Delete(ctx context.Context, filter *Filter) (total int, err error)

	Reset(ctx context.Context) error
	Init(ctx context.Context) error
}
