package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/access_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/users -i Users -t ../../../assets/templates/middleware/access_log -o logging_middleware.go -l ""

import (
	"context"
	"fmt"
	"time"

	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/options"
	"git.perx.ru/perxis/perxis-go/pkg/users"
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

// loggingMiddleware implements users.Users that is instrumented with logging
type loggingMiddleware struct {
	logger *zap.Logger
	next   users.Users
}

// LoggingMiddleware instruments an implementation of the users.Users with simple logging
func LoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next users.Users) users.Users {
		return &loggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *loggingMiddleware) Create(ctx context.Context, create *users.User) (user *users.User, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"create": create} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Create.Request", fields...)

	user, err = m.next.Create(ctx, create)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"user": user,
		"err":  err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Create.Response", fields...)

	return user, err
}

func (m *loggingMiddleware) Delete(ctx context.Context, userId string) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"userId": userId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Delete.Request", fields...)

	err = m.next.Delete(ctx, userId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Delete.Response", fields...)

	return err
}

func (m *loggingMiddleware) Find(ctx context.Context, filter *users.Filter, options *options.FindOptions) (users []*users.User, total int, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":     ctx,
		"filter":  filter,
		"options": options} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Find.Request", fields...)

	users, total, err = m.next.Find(ctx, filter, options)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"users": users,
		"total": total,
		"err":   err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Find.Response", fields...)

	return users, total, err
}

func (m *loggingMiddleware) Get(ctx context.Context, userId string) (user *users.User, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"userId": userId} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Get.Request", fields...)

	user, err = m.next.Get(ctx, userId)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"user": user,
		"err":  err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Get.Response", fields...)

	return user, err
}

func (m *loggingMiddleware) GetByIdentity(ctx context.Context, identity string) (user *users.User, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":      ctx,
		"identity": identity} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("GetByIdentity.Request", fields...)

	user, err = m.next.GetByIdentity(ctx, identity)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"user": user,
		"err":  err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("GetByIdentity.Response", fields...)

	return user, err
}

func (m *loggingMiddleware) Update(ctx context.Context, update *users.User) (err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":    ctx,
		"update": update} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Update.Request", fields...)

	err = m.next.Update(ctx, update)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"err": err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("Update.Response", fields...)

	return err
}
