package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/users -i Users -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
	"git.perx.ru/perxis/perxis-go/pkg/users"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements users.Users that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   users.Users
}

// ErrorLoggingMiddleware instruments an implementation of the users.Users with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next users.Users) users.Users {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Create(ctx context.Context, create *users.User) (user *users.User, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Create(ctx, create)
}

func (m *errorLoggingMiddleware) Delete(ctx context.Context, userId string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Delete(ctx, userId)
}

func (m *errorLoggingMiddleware) Find(ctx context.Context, filter *users.Filter, options *options.FindOptions) (users []*users.User, total int, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Find(ctx, filter, options)
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, userId string) (user *users.User, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, userId)
}

func (m *errorLoggingMiddleware) GetByIdentity(ctx context.Context, identity string) (user *users.User, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.GetByIdentity(ctx, identity)
}

func (m *errorLoggingMiddleware) Update(ctx context.Context, update *users.User) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Update(ctx, update)
}
