package template

import (
	"strings"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
)

// getLookup возвращает функцию для шаблонизатора для получения значений из записи коллекции
// name указывается в виде "<collection id>.<item id>.<field>"
// Использование в шаблонах:  {{ lookup "secrets.key.value" }}
func getLookup(b *Builder) any {
	return func(name string) (any, error) {
		parsedName := strings.Split(name, ".")
		if len(parsedName) < 3 {
			return "", errors.Errorf("incorrect parameter \"%s\"", name)
		}

		collectionID := parsedName[0]
		itemID := parsedName[1]
		field := parsedName[2]
		item, err := b.cnt.Items.Get(b.Context(), b.SpaceID, b.EnvID, collectionID, itemID)
		if err != nil {
			return "", errors.Wrapf(err, "failed to get \"%s\"")
		}

		if len(item.Data) > 0 {
			if v, ok := item.Data[field]; ok {
				return v, nil
			}
		}

		return nil, nil
	}
}

// getSys возвращает функцию получения System
// Использование в шаблонах: {{ system.SpaceID }}
func getSystem(b *Builder) any {
	return func() *System {
		return &System{builder: b}
	}
}
