package spaces

import "context"

type SpaceObserver interface{}

type SpaceCreatedObserver interface {
	OnSpaceCreated(ctx context.Context, space *Space) error
}

type SpaceUpdatedObserver interface {
	OnSpaceUpdated(ctx context.Context, before, space *Space) error
}

type SpaceDeletedObserver interface {
	OnSpaceDeleted(ctx context.Context, space *Space) error
}
