package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/telemetry
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/spaces -i Spaces -t ../../../assets/templates/middleware/telemetry -o telemetry_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/spaces"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
)

// telemetryMiddleware implements spaces.Spaces interface instrumented with opentracing spans
type telemetryMiddleware struct {
	spaces.Spaces
	_instance      string
	_spanDecorator func(span trace.Span, params, results map[string]interface{})
}

// TelemetryMiddleware returns telemetryMiddleware
func TelemetryMiddleware(base spaces.Spaces, instance string, spanDecorator ...func(span trace.Span, params, results map[string]interface{})) telemetryMiddleware {
	d := telemetryMiddleware{
		Spaces:    base,
		_instance: instance,
	}

	if len(spanDecorator) > 0 && spanDecorator[0] != nil {
		d._spanDecorator = spanDecorator[0]
	}

	return d
}

// AbortTransfer implements spaces.Spaces
func (_d telemetryMiddleware) AbortTransfer(ctx context.Context, spaceID string) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.AbortTransfer")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceID": spaceID}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.AbortTransfer(ctx, spaceID)
}

// Create implements spaces.Spaces
func (_d telemetryMiddleware) Create(ctx context.Context, space *spaces.Space) (created *spaces.Space, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.Create")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":   ctx,
				"space": space}, map[string]interface{}{
				"created": created,
				"err":     err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.Create(ctx, space)
}

// Delete implements spaces.Spaces
func (_d telemetryMiddleware) Delete(ctx context.Context, spaceId string) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.Delete")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.Delete(ctx, spaceId)
}

// Get implements spaces.Spaces
func (_d telemetryMiddleware) Get(ctx context.Context, spaceId string) (space *spaces.Space, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.Get")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId}, map[string]interface{}{
				"space": space,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.Get(ctx, spaceId)
}

// List implements spaces.Spaces
func (_d telemetryMiddleware) List(ctx context.Context, orgId string) (spaces []*spaces.Space, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.List")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":   ctx,
				"orgId": orgId}, map[string]interface{}{
				"spaces": spaces,
				"err":    err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.List(ctx, orgId)
}

// ListTransfers implements spaces.Spaces
func (_d telemetryMiddleware) ListTransfers(ctx context.Context, orgID string) (spaces []*spaces.Space, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.ListTransfers")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":   ctx,
				"orgID": orgID}, map[string]interface{}{
				"spaces": spaces,
				"err":    err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.ListTransfers(ctx, orgID)
}

// Move implements spaces.Spaces
func (_d telemetryMiddleware) Move(ctx context.Context, spaceID string, orgID string) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.Move")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceID": spaceID,
				"orgID":   orgID}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.Move(ctx, spaceID, orgID)
}

// Transfer implements spaces.Spaces
func (_d telemetryMiddleware) Transfer(ctx context.Context, spaceID string, transferToOrg string) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.Transfer")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":           ctx,
				"spaceID":       spaceID,
				"transferToOrg": transferToOrg}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.Transfer(ctx, spaceID, transferToOrg)
}

// Update implements spaces.Spaces
func (_d telemetryMiddleware) Update(ctx context.Context, space *spaces.Space) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.Update")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":   ctx,
				"space": space}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.Update(ctx, space)
}

// UpdateConfig implements spaces.Spaces
func (_d telemetryMiddleware) UpdateConfig(ctx context.Context, spaceId string, config *spaces.Config) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Spaces.UpdateConfig")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"spaceId": spaceId,
				"config":  config}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Spaces.UpdateConfig(ctx, spaceId, config)
}
