package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/recovery
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/spaces -i Spaces -t ../../../assets/templates/middleware/recovery -o recovering_middleware.go -l ""

import (
	"context"
	"fmt"

	"git.perx.ru/perxis/perxis-go/pkg/spaces"
	"go.uber.org/zap"
)

// recoveringMiddleware implements spaces.Spaces that is instrumented with logging
type recoveringMiddleware struct {
	logger *zap.Logger
	next   spaces.Spaces
}

// RecoveringMiddleware instruments an implementation of the spaces.Spaces with simple logging
func RecoveringMiddleware(logger *zap.Logger) Middleware {
	return func(next spaces.Spaces) spaces.Spaces {
		return &recoveringMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *recoveringMiddleware) AbortTransfer(ctx context.Context, spaceID string) (err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.AbortTransfer(ctx, spaceID)
}

func (m *recoveringMiddleware) Create(ctx context.Context, space *spaces.Space) (created *spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Create(ctx, space)
}

func (m *recoveringMiddleware) Delete(ctx context.Context, spaceId string) (err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Delete(ctx, spaceId)
}

func (m *recoveringMiddleware) Get(ctx context.Context, spaceId string) (space *spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Get(ctx, spaceId)
}

func (m *recoveringMiddleware) List(ctx context.Context, orgId string) (spaces []*spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.List(ctx, orgId)
}

func (m *recoveringMiddleware) ListTransfers(ctx context.Context, orgID string) (spaces []*spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.ListTransfers(ctx, orgID)
}

func (m *recoveringMiddleware) Move(ctx context.Context, spaceID string, orgID string) (err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Move(ctx, spaceID, orgID)
}

func (m *recoveringMiddleware) Transfer(ctx context.Context, spaceID string, transferToOrg string) (err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Transfer(ctx, spaceID, transferToOrg)
}

func (m *recoveringMiddleware) Update(ctx context.Context, space *spaces.Space) (err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Update(ctx, space)
}

func (m *recoveringMiddleware) UpdateConfig(ctx context.Context, spaceId string, config *spaces.Config) (err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.UpdateConfig(ctx, spaceId, config)
}
