package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/spaces -i Spaces -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/spaces"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements spaces.Spaces that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   spaces.Spaces
}

// ErrorLoggingMiddleware instruments an implementation of the spaces.Spaces with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next spaces.Spaces) spaces.Spaces {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) AbortTransfer(ctx context.Context, spaceID string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.AbortTransfer(ctx, spaceID)
}

func (m *errorLoggingMiddleware) Create(ctx context.Context, space *spaces.Space) (created *spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Create(ctx, space)
}

func (m *errorLoggingMiddleware) Delete(ctx context.Context, spaceId string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Delete(ctx, spaceId)
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, spaceId string) (space *spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, spaceId)
}

func (m *errorLoggingMiddleware) List(ctx context.Context, orgId string) (spaces []*spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.List(ctx, orgId)
}

func (m *errorLoggingMiddleware) ListTransfers(ctx context.Context, orgID string) (spaces []*spaces.Space, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.ListTransfers(ctx, orgID)
}

func (m *errorLoggingMiddleware) Move(ctx context.Context, spaceID string, orgID string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Move(ctx, spaceID, orgID)
}

func (m *errorLoggingMiddleware) Transfer(ctx context.Context, spaceID string, transferToOrg string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Transfer(ctx, spaceID, transferToOrg)
}

func (m *errorLoggingMiddleware) Update(ctx context.Context, space *spaces.Space) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Update(ctx, space)
}

func (m *errorLoggingMiddleware) UpdateConfig(ctx context.Context, spaceId string, config *spaces.Config) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.UpdateConfig(ctx, spaceId, config)
}
