package validate

import (
	"context"
	"errors"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

type required bool

func Required() Validator {
	r := required(true)
	return &r
}

func (r required) Validate(_ context.Context, f *field.Field, value interface{}) error {

	if value != nil {
		t, ok := f.GetType().(interface{ IsEmpty(interface{}) bool })
		if ok && !t.IsEmpty(value) {
			return nil
		}

		/*
			tt, ok := f.GetType().(interface {
					IsEmpty(interface{}) (bool, error)
				})
				empty, err := tt.IsEmpty(value)
				if err != nil {
					return err
				}
				if ok && !empty {
					return nil
				}
		*/
	}

	return errors.New("value is required")

}

func (r required) ValidateOption() error {
	if !r {
		return field.ErrSkipOption
	}
	return nil
}
