package validate

import (
	"context"
	"errors"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

type readonly bool

func ReadOnly() Validator {
	r := readonly(true)
	return &r
}

func (r readonly) Validate(_ context.Context, f *field.Field, value interface{}) error {
	if value != nil {
		return errors.New("value is readonly")
	}
	return nil

}

func (r readonly) ValidateOption() error {
	if !r {
		return field.ErrSkipOption
	}
	return nil
}
