package validate

import (
	"context"
	"fmt"
	"math"
	"reflect"
	"strconv"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

type max float64

func Max(m float64) Validator {
	v := max(m)
	return &v
}

func (t max) Validate(_ context.Context, field *field.Field, value interface{}) error {
	var num float64
	switch v := value.(type) {
	case int:
		num = float64(v)
	case int8:
		num = float64(v)
	case int32:
		num = float64(v)
	case int64:
		num = float64(v)
	case uint:
		num = float64(v)
	case uint8:
		num = float64(v)
	case uint32:
		num = float64(v)
	case uint64:
		num = float64(v)
	case float32:
		num = float64(v)
	case float64:
		num = v
	case nil:
		return nil
	default:
		return fmt.Errorf("incorrect type: \"%s\", expected \"number\"", reflect.ValueOf(v).Kind())
	}
	if num > float64(t) {
		return fmt.Errorf("maximum number is %s, got %s", strconv.FormatFloat(float64(t), 'f', -1, 64), strconv.FormatFloat(float64(num), 'f', -1, 64))
	}
	return nil

}

type min float64

func Min(m float64) Validator {
	v := min(m)
	return &v
}

func (t min) Validate(_ context.Context, fld *field.Field, value interface{}) error {
	var num float64
	switch v := value.(type) {
	case int:
		num = float64(v)
	case int8:
		num = float64(v)
	case int32:
		num = float64(v)
	case int64:
		num = float64(v)
	case uint:
		num = float64(v)
	case uint8:
		num = float64(v)
	case uint32:
		num = float64(v)
	case uint64:
		num = float64(v)
	case float32:
		num = float64(v)
	case float64:
		num = v
	case nil:
		return nil
	default:
		return fmt.Errorf("incorrect type: \"%s\", expected \"number\"", reflect.ValueOf(v).Kind())
	}
	if num < float64(t) {
		return fmt.Errorf("minimum number is %s, got %s", strconv.FormatFloat(float64(t), 'f', -1, 64), strconv.FormatFloat(float64(num), 'f', -1, 64))
	}
	return nil
}

type multipleOf float64

func MultipleOf(d float64) Validator {
	v := multipleOf(d)
	return &v
}

func (t multipleOf) Validate(_ context.Context, field *field.Field, value interface{}) error {
	var num float64
	switch v := value.(type) {
	case int:
		num = float64(v)
	case int8:
		num = float64(v)
	case int32:
		num = float64(v)
	case int64:
		num = float64(v)
	case uint:
		num = float64(v)
	case uint8:
		num = float64(v)
	case uint32:
		num = float64(v)
	case uint64:
		num = float64(v)
	case float32:
		num = float64(v)
	case float64:
		num = v
	case nil:
		return nil
	default:
		return fmt.Errorf("incorrect type: \"%s\", expected \"number\"", reflect.ValueOf(v).Kind())
	}
	if math.Mod(num, float64(t)) != 0 {
		return fmt.Errorf("number must be a multiple of %f", t)

	}
	return nil
}
