package validate

import (
	"context"
	"fmt"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
	"github.com/pkg/errors"
)

type EnumUI struct {
	Color string `json:"color,omitempty"`
	Icon  string `json:"icon,omitempty"`
	Spin  bool   `json:"spin,omitempty"`
	Blink bool   `json:"blink,omitempty"`
}

type EnumOpt struct {
	Name  string      `json:"name"`
	Value interface{} `json:"value"`
	UI    *EnumUI     `json:"ui,omitempty"`
}

func (o EnumOpt) String() string {
	return fmt.Sprintf("%s", o.Value)
}

type enum []EnumOpt

func Enum(opts ...EnumOpt) Validator {
	var e enum
	for _, i := range opts {
		e = append(e, i)
	}
	return &e
}

func (t enum) Validate(ctx context.Context, f *field.Field, value interface{}) error {
	// Значение может отсутствовать, что не является ошибкой
	if value == nil {
		return nil
	}

	if f.AdditionalValues {
		return nil
	}

	for _, i := range t {
		enumValue, err := field.Decode(ctx, f, i.Value)
		if err != nil {
			return fmt.Errorf("error decode option value: %w", err)
		}
		if value == enumValue {
			return nil
		}
	}

	return errors.Errorf("value required to be one of %s", t)
}

func (t enum) ValidateOption() error {
	for _, i := range t {
		if i.Name == "" {
			return errors.Errorf("enum name is required")
		}
	}
	return nil
}
