package validate

import (
	"context"
	"fmt"
	"reflect"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

type maxItems int

func MaxItems(max int) Validator {
	v := maxItems(max)
	return &v
}

func (t maxItems) Validate(_ context.Context, _ *field.Field, value interface{}) error {
	if value == nil {
		return nil
	}
	v := reflect.ValueOf(value)
	if !v.IsValid() || v.Kind() != reflect.Array && v.Kind() != reflect.Slice {
		return fmt.Errorf("incorrect type: \"%s\", expected \"array\"", v.Kind())
	}
	if t > 0 && v.Len() > int(t) {
		return fmt.Errorf("maximum elements number is %d", t)
	}
	return nil
}

type minItems int

func MinItems(min int) Validator {
	v := minItems(min)
	return &v
}

func (t minItems) Validate(_ context.Context, _ *field.Field, value interface{}) error {
	if value == nil {
		return nil
	}
	v := reflect.ValueOf(value)
	if !v.IsValid() || v.Kind() != reflect.Array && v.Kind() != reflect.Slice {
		return fmt.Errorf("incorrect type: \"%s\", expected \"array\"", v.Kind())
	}
	if t > 0 && v.Len() < int(t) {
		return fmt.Errorf("minimum elements number is %d", t)
	}
	return nil
}
