package modify

import (
	"reflect"
	"testing"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

func TestValue(t *testing.T) {
	tests := []struct {
		name    string
		field   *field.Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{"Condition with _value", field.String().AddOptions(Value("_value == 'ab' ? _value : _value + 'b'")), "a", "ab", false},
		{"Condition with _value", field.String().AddOptions(Value("_value == 'ab' ? _value : _value + 'b'")), "ab", "ab", false},
		{"Default with _value", field.String().AddOptions(Value("_value == nil ? 'abc' : _value")), nil, "abc", false},
		{"Field global", field.Object(
			"fld1", field.String(),
			"fld2", field.String().AddOptions(Value("fld1 + 'b'")),
		),
			map[string]interface{}{"fld1": "a"},
			map[string]interface{}{"fld1": "a", "fld2": "ab"}, false},
		{"Field local", field.Object(
			"fld1", field.String(),
			"fld2", field.String().AddOptions(Value("_.fld1 + 'b'")),
		),
			map[string]interface{}{"fld1": "a"},
			map[string]interface{}{"fld1": "a", "fld2": "ab"}, false},
		{"Multiple fields ", field.Object(
			"fld1", field.String(),
			"fld2", field.String(),
			"fld3", field.String(),
			"fld4", field.String(),
			"fld5", field.String().AddOptions(Value("_.fld1 + fld2 + _.fld3+fld4")),
		),
			map[string]interface{}{"fld1": "a", "fld2": "b", "fld3": "c", "fld4": "d"},
			map[string]interface{}{"fld1": "a", "fld2": "b", "fld3": "c", "fld4": "d", "fld5": "abcd"},
			false},
		{"Nil field error", field.Object(
			"fld1", field.String(),
			"fld2", field.String().AddOptions(Value("_.fld1 + 'b'")),
		),
			map[string]interface{}{},
			map[string]interface{}{},
			true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, _, err := Modify(nil, tt.field, tt.data)
			if (err != nil) != tt.wantErr {
				t.Errorf("Modify() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !tt.wantErr && !reflect.DeepEqual(got, tt.want) {
				t.Errorf("Modify() got = %v, want %v", got, tt.want)
			}
		})
	}
}
