package modify

import (
	"context"
	"encoding/json"
	"reflect"

	"git.perx.ru/perxis/perxis-go/pkg/expr"
	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
	"github.com/pkg/errors"
)

type value struct {
	Expression string
}

func (d *value) UnmarshalJSON(bytes []byte) error {
	return json.Unmarshal(bytes, &d.Expression)
}

func (d value) MarshalJSON() ([]byte, error) {
	return json.Marshal(d.Expression)
}

func Value(exp string) Modifier {
	return &value{Expression: exp}
}

func (d value) Modify(ctx context.Context, f *field.Field, v interface{}) (interface{}, bool, error) {
	val, err := expr.EvalKV(ctx, d.Expression, "_value", v)
	if err != nil {
		return nil, false, errors.Wrap(err, "value evaluation error")
	}
	// использование reflect.DeepEqual для учета случаев, когда в val массив или объект
	if !reflect.DeepEqual(val, v) {
		return val, true, nil
	}
	return v, false, nil
}
