package modify

import (
	"context"
	"fmt"
	"reflect"
	"strings"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

type trimSpace bool

func TrimSpace() Modifier {
	t := trimSpace(true)
	return &t
}

func (c trimSpace) Modify(ctx context.Context, field *field.Field, v interface{}) (interface{}, bool, error) {
	if !c {
		return v, false, nil
	}

	if v == nil {
		return nil, false, nil
	}

	if s, ok := v.(string); ok {
		s = strings.TrimSpace(s)
		return s, true, nil
	}
	return nil, false, fmt.Errorf("incorrect type: \"%s\", expected \"string\"", reflect.ValueOf(v).Kind())
}
