package modify

import (
	"context"
	"encoding/json"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

type defaultValue struct {
	Value interface{}
	ready bool
}

func (d *defaultValue) Prepare(f *field.Field) error {
	var err error
	d.Value, err = field.Decode(nil, f, d.Value)
	return err
}

func (d *defaultValue) UnmarshalJSON(bytes []byte) error {
	return json.Unmarshal(bytes, &d.Value)
}

func (d defaultValue) MarshalJSON() ([]byte, error) {
	return json.Marshal(d.Value)
}

func Default(v interface{}) Modifier {
	return &defaultValue{Value: v}
}

func (defaultValue) GetName() string { return "default" }

func (d defaultValue) Modify(ctx context.Context, f *field.Field, v interface{}) (interface{}, bool, error) {
	if !d.ready {
		var err error
		if d.Value, err = field.Decode(ctx, f, d.Value); err != nil {
			return nil, false, err
		}
	}

	if v == nil && d.Value != nil {
		return d.Value, true, nil
	}
	return v, false, nil
}
