package schema

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
)

var defaultLoader field.Loader

func SetDefaultLoader(l field.Loader) {
	defaultLoader = l
}

func GetLoader() field.Loader {
	return defaultLoader
}

func Load(ctx context.Context, ref string) (*Schema, error) {
	s := New()
	if err := s.Field.LoadRef(ctx, ref, GetLoader()); err != nil {
		return nil, err
	}
	return s, nil
}
