package field

import (
	"encoding/json"

	jsoniter "github.com/json-iterator/go"
	"github.com/pkg/errors"
)

var unknownType = &UnknownType{}

type UnknownParameters struct {
	Typ    string          `json:"type,omitempty"`
	Params json.RawMessage `json:"params,omitempty"`
}

func (UnknownParameters) Type() Type                    { return unknownType }
func (p UnknownParameters) Clone(reset bool) Parameters { return &p }

type UnknownType struct{}

func (UnknownType) Name() string {
	return "unknown"
}

func (UnknownType) NewParameters() Parameters {
	return &UnknownParameters{}
}

func (UnknownType) ConvertParameters(p Parameters) (Parameters, error) {
	unknownParams, ok := p.(*UnknownParameters)
	if !ok {
		return p, nil
	}

	// Проверяем возможность восстановления исходного типа поля и возвращаем его если возможно
	typ, ok := GetType(unknownParams.Typ)
	if !ok {
		return p, nil
	}

	params := typ.NewParameters()
	if len(unknownParams.Params) > 0 {
		if err := jsoniter.Unmarshal(unknownParams.Params, params); err != nil {
			return p, errors.Wrapf(err, "error recover field type %s", typ.Name())
		}
	}

	return params, nil
}

func Unknown(typ string, params json.RawMessage, o ...interface{}) *Field {
	var pc ParametersConverter
	pc = unknownType
	_ = pc
	return NewField(&UnknownParameters{Typ: typ, Params: params}, o...)
}
