package field

import (
	"context"
	"fmt"
	"reflect"
)

var stringType = &StringType{}

type StringParameters struct{}

func (s StringParameters) Type() Type                   { return stringType }
func (s *StringParameters) Clone(reset bool) Parameters { return s }

type StringType struct{}

func (s StringType) Name() string {
	return "string"
}

func (StringType) NewParameters() Parameters {
	return &StringParameters{}
}

func (StringType) IsEmpty(v interface{}) bool {
	s, _ := v.(string)
	return s == ""
}

func (StringType) Decode(_ context.Context, _ *Field, v interface{}) (interface{}, error) {
	if v == nil {
		return nil, nil
	}
	if _, ok := v.(string); ok {
		return v, nil
	}
	return nil, fmt.Errorf("StringField decode error: unsupported value type : \"%s\"", reflect.ValueOf(v).Kind())
}

func (StringType) Encode(_ context.Context, _ *Field, v interface{}) (interface{}, error) {
	if v == nil {
		return nil, nil
	}
	if _, ok := v.(string); ok {
		return v, nil
	}
	return nil, fmt.Errorf("StringField encode error: unsupported value type : \"%s\"", reflect.ValueOf(v).Kind())
}

func String(o ...interface{}) *Field {
	return NewField(&StringParameters{}, o...)
}
