package field

import (
	"reflect"
	"testing"
)

func TestNumberField_Decode(t *testing.T) {
	tests := []struct {
		name    string
		field   *Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{"Correct", Number("int"), int64(2), int64(2), false},     // #0
		{"Correct", Number("int"), 2.2, int64(2), false},          // #1
		{"Correct", Number("int"), 2, int64(2), false},            // #2
		{"Correct", Number("int"), float32(2.2), int64(2), false}, // #3
		{"Correct", Number("int"), float64(2.6), int64(3), false}, // #4
		{"Correct", Number("int"), 2.6, int64(3), false},          // #5

		{"Correct", Number("float"), int8(2), 2.0, false},                    // #6
		{"Correct", Number("float"), 2.2, 2.2, false},                        // #7
		{"Correct", Number("float"), 2, 2.0, false},                          // #8
		{"Correct", Number("float"), float32(2.2), 2.200000047683716, false}, // #9
		{"Correct", Number("float"), int64(2), 2.0, false},                   // #10

		{"Wrong data", Number("int"), "", nil, true},         // #0
		{"Wrong data", Number("int"), []byte(""), nil, true}, // #1

		{"Wrong data", Number("float"), "", nil, true},         // #2
		{"Wrong data", Number("float"), []byte(""), nil, true}, // #3
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := Decode(nil, tt.field, tt.data)
			if (err != nil) != tt.wantErr {
				t.Errorf("Decode() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("Decode() got = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestNumberField_Encode(t *testing.T) {
	tests := []struct {
		name    string
		field   *Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{"Correct", Number("int"), int64(2), int64(2), false},     // #0
		{"Correct", Number("int"), 2.2, int64(2), false},          // #1
		{"Correct", Number("int"), 2, int64(2), false},            // #2
		{"Correct", Number("int"), float32(2.2), int64(2), false}, // #3
		{"Correct", Number("int"), float32(2.6), int64(3), false}, // #4
		{"Correct", Number("int"), 2.6, int64(3), false},          // #5

		{"Correct", Number("float"), int8(2), 2.0, false},                    // #6
		{"Correct", Number("float"), 2.2, 2.2, false},                        // #7
		{"Correct", Number("float"), 2, 2.0, false},                          // #8
		{"Correct", Number("float"), float32(2.2), 2.200000047683716, false}, // #9
		{"Correct", Number("float"), int64(2), 2.0, false},                   // #10

		{"Wrong data", Number("int"), "", nil, true},         // #0
		{"Wrong data", Number("int"), []byte(""), nil, true}, // #1

		{"Wrong data", Number("float"), "", nil, true},         // #2
		{"Wrong data", Number("float"), []byte(""), nil, true}, // #3
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := Encode(nil, tt.field, tt.data)
			if (err != nil) != tt.wantErr {
				t.Errorf("Decode() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("Decode() got = %v, want %v", got, tt.want)
			}
		})
	}
}
