package field

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
	"git.perx.ru/perxis/perxis-go/pkg/expr"
)

const EvaluatePassesLimit = 10

func Evaluate(ctx context.Context, w Walker, v interface{}) (interface{}, error) {
	var err error

	chg := true
	val := v
	i := 0

	for chg {
		m, _ := val.(map[string]interface{})

		val, chg, err = w.Walk(expr.WithEnv(ctx, m), val, func(ctx context.Context, f *Field, v interface{}) (res WalkFuncResult, err error) {
			enabled, _ := f.IsEnabled(ctx)

			if !enabled {
				res.Stop = true
				if v != nil {
					res.Changed = true // Значение изменилось на пустое
				}
				return
			}

			res.Value = v
			return
		})

		if err != nil {
			return nil, errors.Wrap(err, "evaluation error")
		}

		i += 1

		if i > EvaluatePassesLimit {
			return nil, errors.New("fail to evaluate data conditions")
		}
	}

	return val, nil
}
