package field

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/errors"
)

type Decoder interface {
	Decode(ctx context.Context, field *Field, v interface{}) (interface{}, error)
}

type Encoder interface {
	Encode(ctx context.Context, field *Field, v interface{}) (interface{}, error)
}

func Decode(ctx context.Context, w Walker, v interface{}) (interface{}, error) {
	var err error
	//if ctx == nil {
	//	ctx = NewContext()
	//}
	//
	//if m, ok := v.(map[string]interface{}); ok {
	//	ctx = ctx.ExtendEnv(m)
	//	ctx.DisableConditions = true
	//}

	val, _, err := w.Walk(ctx, v, func(ctx context.Context, f *Field, v interface{}) (res WalkFuncResult, err error) {
		if decoder, ok := f.GetType().(Decoder); ok {
			if v, err = decoder.Decode(ctx, f, v); err != nil {
				return
			}
			res.Value = v
			res.Changed = true
			return
		}
		res.Value = v
		return
	})

	if err != nil {
		return nil, errors.Wrap(err, "decode error")
	}

	return val, nil
}

func Encode(ctx context.Context, w Walker, v interface{}) (interface{}, error) {
	val, _, err := w.Walk(ctx, v, func(ctx context.Context, f *Field, v interface{}) (res WalkFuncResult, err error) {
		if encode, ok := f.GetType().(Encoder); ok {
			if v, err = encode.Encode(ctx, f, v); err != nil {
				return
			}
			res.Value = v
			res.Changed = true
			return
		}
		res.Value = v
		return
	})
	if err != nil {
		return nil, errors.Wrap(err, "encode error")
	}
	return val, nil

}
