package roles

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Create(ctx context.Context, role *Role) (created *Role, err error)
	Find(ctx context.Context, spaceID string, f *Filter, opts *options.FindOptions) ([]*Role, int, error)
	Update(ctx context.Context, role *Role) (updated, total int, err error)
	Delete(ctx context.Context, spaceID, roleID string) (err error)

	Reset(ctx context.Context, spaceID string) error
}

type Filter struct {
	ID   string
	Name string
}
