package roles

import (
	"context"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/roles
// @grpc-addr content.roles.Roles
type Roles interface {
	Create(ctx context.Context, role *Role) (created *Role, err error)
	Get(ctx context.Context, spaceId, roleId string) (role *Role, err error)
	List(ctx context.Context, spaceId string) (roles []*Role, err error)
	Update(ctx context.Context, role *Role) (err error)
	Delete(ctx context.Context, spaceId, roleId string) (err error)
}
