package middleware

// DO NOT EDIT!
// This code is generated with http://github.com/hexdigest/gowrap tool
// using ../../../assets/templates/middleware/error_log template

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/references -i References -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/references"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements references.References that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   references.References
}

// ErrorLoggingMiddleware instruments an implementation of the references.References with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next references.References) references.References {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, spaceId string, envId string, references []*references.Reference) (items []*items.Item, notfound []*references.Reference, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, spaceId, envId, references)
}

func (m *errorLoggingMiddleware) Publish(ctx context.Context, spaceId string, envId string, references []*references.Reference, recursive bool, force bool) (published []*references.Reference, notfound []*references.Reference, unpublished []*references.Reference, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Publish(ctx, spaceId, envId, references, recursive, force)
}
