package queue

import (
	"sync/atomic"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func f(v *int32, timeout int) (err error) {
	atomic.AddInt32(v, 1)
	time.Sleep(time.Millisecond * time.Duration(timeout))
	return
}

func TestDefaultQueueRun(t *testing.T) {
	var v int32
	q := &Queue{}
	q.Start()

	jg := &JobGroup{}
	for i := 0; i < 100; i++ {
		j := func() (err error) {
			return f(&v, 1)
		}
		_, err := q.AddJob(jg.Add(j))
		require.NoError(t, err)
	}
	jg.Wait()
	q.Stop()
	assert.Equal(t, int32(100), v)
}

func TestQueueSizeExceededError(t *testing.T) {
	var v int32
	q := &Queue{NumWorkers: 1, Size: 2}
	q.Start()

	// попадает в очередь без ошибки
	j := func() (err error) {
		return f(&v, 10)
	}

	var err error
	var i int
	for i = 0; i < 5; i++ {
		_, err = q.AddJob(j)
		if err != nil {
			break
		}
	}

	require.Error(t, err)
	assert.Equal(t, "queue size exceeded", err.Error())
	assert.Greater(t, i, 1)

	q.Stop()
}
